% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lint.R
\name{lint}
\alias{lint}
\title{Validate WKT strings}
\usage{
lint(str)
}
\arguments{
\item{str}{A WKT string}
}
\value{
A logical (\code{TRUE} or \code{FALSE})
}
\description{
Validate WKT strings
}
\examples{
lint("POINT (1 2)")
lint("POINT (1 2 3)")
lint("LINESTRING EMPTY")
lint("LINESTRING (100 0, 101 1)")
lint("MULTIPOINT EMPTY")
lint("MULTIPOINT ((1 2), (3 4))")
lint("MULTIPOINT ((1 2), (3 4), (-10 100))")
lint("POLYGON ((1 2, 3 4, 0 5, 1 2))")
lint("POLYGON((20.3 28.6, 20.3 19.6, 8.5 19.6, 8.5 28.6, 20.3 28.6))")
lint("MULTIPOLYGON (((30 20, 45 40, 10 40, 30 20)), ((15 5, 40 10, 10 20, 5 10, 15 5)))")
lint("TRIANGLE ((0 0, 0 1, 1 1, 0 0))")
lint("TRIANGLE ((0.1 0.1, 0.1 1.1, 1.1 1.1, 0.1 0.1))")
lint("CIRCULARSTRING (1 5, 6 2, 7 3)")
lint("CIRCULARSTRING (1 5, 6 2, 7 3, 5 6, 4 3)")
lint('COMPOUNDCURVE (CIRCULARSTRING (1 0, 0 1, -1 0), (-1 0, 2 0))')
}

