% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circularstring.R
\name{circularstring}
\alias{circularstring}
\title{Make WKT circularstring objects}
\usage{
circularstring(..., fmt = 16)
}
\arguments{
\item{...}{A GeoJSON-like object representing a Point, LineString, Polygon,
MultiPolygon, etc.}

\item{fmt}{Format string which indicates the number of digits to display
after the decimal point when formatting coordinates. Max: 20}
}
\description{
Make WKT circularstring objects
}
\examples{
## empty circularstring
circularstring("empty")
# circularstring("stuff")

# Character string
circularstring("CIRCULARSTRING(1 5, 6 2, 7 3)")

# data.frame
df <- data.frame(lon = c(-116.4, -118), lat = c(45.2, 47))
circularstring(df, fmt=1)
df <- data.frame(lon=c(-116.4, -118, -120), lat=c(45.2, 47, 49))
circularstring(df, fmt=1)

# matrix
mat <- matrix(c(-116.4,-118, 45.2, 47), ncol = 2)
circularstring(mat, fmt=1)
mat2 <- matrix(c(-116.4, -118, -120, 45.2, 47, 49), ncol = 2)
circularstring(mat2, fmt=1)

# list
x <- list(c(1, 5), c(6, 2), c(7, 3))
circularstring(x, fmt=2)
}
\seealso{
Other R-objects: \code{\link{geometrycollection}},
  \code{\link{linestring}}, \code{\link{multilinestring}},
  \code{\link{multipoint}}, \code{\link{multipolygon}},
  \code{\link{point}}, \code{\link{polygon}}
}
