% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.json.R
\name{as_json}
\alias{as_json}
\title{Convert geojson R list to JSON}
\usage{
as_json(x, pretty = TRUE, auto_unbox = TRUE, ...)
}
\arguments{
\item{x}{Output from \code{\link[=wkt2geojson]{wkt2geojson()}}}

\item{pretty}{(logical) Adds indentation whitespace to JSON output. Can
be \code{TRUE}/\code{FALSE} or a number specifying the number of spaces to indent.
See \code{\link[jsonlite:prettify]{jsonlite::prettify()}}. Default: \code{TRUE}. Having \code{TRUE} as default
makes it easy to copy paste to a text editor, etc.}

\item{auto_unbox}{(logical) Automatically unbox all atomic vectors of
length 1. Default: \code{TRUE}}

\item{...}{Further args passed on to \code{\link[jsonlite:toJSON]{jsonlite::toJSON()}}}
}
\description{
Convert geojson R list to JSON
}
\examples{
str <- "POLYGON ((100 0.1, 101.1 0.3, 101 0.5, 100 0.1),
   (103.2 0.2, 104.8 0.2, 100.8 0.8, 103.2 0.2))"
as_json(wkt2geojson(str))
as_json(wkt2geojson(str), FALSE)
}
