% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilinestring.R
\name{multilinestring}
\alias{multilinestring}
\title{Make WKT multilinestring objects}
\usage{
multilinestring(..., fmt = 16, third = "z")
}
\arguments{
\item{...}{A GeoJSON-like object representing a Point, LineString, Polygon,
MultiPolygon, etc.}

\item{fmt}{Format string which indicates the number of digits to display
after the decimal point when formatting coordinates. Max: 20}

\item{third}{(character) Only applicable when there are three dimensions.
If \code{m}, assign a \code{M} value for a measurement, and if \code{z} assign a
\code{Z} value for three-dimenionsal system. Case is ignored. An \code{M} value
represents  a measurement, while a \code{Z} value usually represents altitude
(but can be something like depth in a water based location).}
}
\description{
Make WKT multilinestring objects
}
\details{
There is no \code{numeric} input option for multilinestring.
There is no way as of yet to make a nested multilinestring with
\code{data.frame} input, but you can do so with list input. See examples.
}
\examples{
## empty multilinestring
multilinestring("empty")
# multilinestring("stuff")

# character string
x <- "MULTILINESTRING ((30 20, 45 40, 10 40), (15 5, 40 10, 10 20))"
multilinestring(x)

# data.frame
df <- data.frame(long = c(30, 45, 10), lat = c(20, 40, 40))
df2 <- data.frame(long = c(15, 40, 10), lat = c(5, 10, 20))
multilinestring(df, df2, fmt=0)
lint(multilinestring(df, df2, fmt=0))
wktview(multilinestring(df, df2), zoom=3)

# matrix
mat <- matrix(c(df$long, df$lat), ncol = 2)
mat2 <- matrix(c(df2$long, df2$lat), ncol = 2)
multilinestring(mat, mat2, fmt=0)

# list
x1 <- list(c(30, 20), c(45, 40), c(10, 40))
x2 <- list(c(15, 5), c(40, 10), c(10, 20))
multilinestring(x1, x2, fmt=2)

polys <- list(
  list(c(30, 20), c(45, 40), c(10, 40)),
  list(c(15, 5), c(40, 10), c(10, 20))
)
wktview(multilinestring(polys, fmt=2), zoom=3)

# 3D
## data.frame
df <- data.frame(long = c(30, 45, 10), lat = c(20, 40, 40), altitude = 1:3)
df2 <- data.frame(long = c(15, 40, 10), lat = c(5, 10, 20), altitude = 1:3)
multilinestring(df, df2, fmt=0)
multilinestring(df, df2, fmt=0, third = "m")
## matrix
mat <- matrix(unname(unlist(df)), ncol = 3)
mat2 <- matrix(unname(unlist(df2)), ncol = 3)
multilinestring(mat, mat2, fmt=0)
multilinestring(mat, mat2, fmt=0, third = "m")
## list
x1 <- list(c(30, 20, 1), c(45, 40, 1), c(10, 40, 1))
x2 <- list(c(15, 5, 0), c(40, 10, 3), c(10, 20, 4))
multilinestring(x1, x2, fmt=2)
multilinestring(x1, x2, fmt=2, third = "m")


# 4D
## data.frame
df <- data.frame(long = c(30, 45, 10), lat = c(20, 40, 40), 
  altitude = 1:3, weight = 4:6)
df2 <- data.frame(long = c(15, 40, 10), lat = c(5, 10, 20), 
  altitude = 1:3, weight = 4:6)
multilinestring(df, df2, fmt=0)
## matrix
mat <- matrix(unname(unlist(df)), ncol = 4)
mat2 <- matrix(unname(unlist(df2)), ncol = 4)
multilinestring(mat, mat2, fmt=0)
## list
x1 <- list(c(30, 20, 1, 40), c(45, 40, 1, 40), c(10, 40, 1, 40))
x2 <- list(c(15, 5, 0, 40), c(40, 10, 3, 40), c(10, 20, 4, 40))
multilinestring(x1, x2, fmt=2)
}
\seealso{
Other R-objects: 
\code{\link{circularstring}()},
\code{\link{geometrycollection}()},
\code{\link{linestring}()},
\code{\link{multipoint}()},
\code{\link{multipolygon}()},
\code{\link{point}()},
\code{\link{polygon}()}
}
\concept{R-objects}
