% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdists.R
\name{prop.belowthreshold}
\alias{prop.belowthreshold}
\title{Proportions of cases and controls below a threshold of weight of evidence}
\usage{
prop.belowthreshold(densities, w.threshold)
}
\arguments{
\item{densities}{Densities object produced by \code{\link{Wdensities}}.}

\item{w.threshold}{Threshold value of weight of evidence (natural logs).}
}
\value{
Numeric vector of length 2 listing the proportions of controls and
cases with weight of evidence below the given threshold.
}
\description{
Proportions of cases and controls below a threshold of weight of evidence
}
\examples{
data("cleveland")
densities <- with(cleveland, Wdensities(y, posterior.p, prior.p))
w.threshold <- log(4) # threshold Bayes factor of 4
prop.belowthreshold(densities, w.threshold)

}
