\name{JensenFactor}
\alias{JensenFactor}

\title{For a given distance \code{x}, computes the penalty factor for a turbine's wake.}

\description{
In Jensen's wake model, a wake cone is generated by a turbine based on the turbine's hub height z, its rotor radius r_0, the terrain's roughness length z_0 and the distance x between the turbine under investigation and a certain second point. z, r_0 and z_0 are taken from the \code{\link{FarmVars}} settings object, while x is to be provided.
}

\usage{
JensenFactor(x)
}

\arguments{
	\item{x}{
		must be a single value. Provide distance in meters.
	}
}

\details{
If a second turbine (B) is in a first turbine (A)'s wake, turbine B's power output must be penalized due to turbulence. This function computes the penalty factor for that wake.
}

\value{
\code{JensenFactor} returns the a single number between 0 and 1, which can immediately be used a a penalty factor.
}

\references{
Jensen, N. O. (1983). A note on wind generator interaction. Roskilde: Risø National Laboratory. Risø-M, No. 2411
}

\author{
Carsten Croonenbroeck
}

\note{
Note that for Jensen's multiple wake model, wake penalties from several potentially influencing upwind turbines must be computed. As the factors are between 0 and 1, they can conveniently multiplied by each other afterward. If there are four turbines (A, B, C, D) inside a wind farm, you are investigating turbine D and it turns out that D is in the wake of B and C, but not A, then compute penalty for B (assume 0.7) and C (assume 0.8). Now, the penalty factors for A, B and C are 1, 0.7 and 0.8, so 1 * 0.7 * 0.8 = 0.56 is the penalty for turbine D.
}

\seealso{
Use \code{\link{JensenAngle}} to compute the wake cone and with it, use \code{\link{JensenTrapezoid}} to see if another turbine B is in turbine A's wake. Apply \code{JensenFactor} only if this is the case.
}

\examples{
JensenFactor(500)
## Provided that turbine B is in turbine A's wake and that the two turbines are 500 meters apart,
## turbine B must be penalized by a factor of 0.7952.
}

\keyword{Jensen}
\keyword{Profit}
