% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whatr-scores.R
\name{whatr_scores}
\alias{whatr_scores}
\title{What are player scores?}
\format{
A tibble with (up to) 61 rows and 5 variables:
\describe{
\item{round}{The round a clue is chosen.}
\item{i}{The order of clue chosen.}
\item{name}{First name of player responding.}
\item{score}{Change in score from this clue.}
\item{double}{Is the clue a daily double.}
}
}
\usage{
whatr_scores(game)
}
\arguments{
\item{game}{One of four types of input, all passed to \code{\link[=whatr_html]{whatr_html()}}:
\enumerate{
\item A numeric game ID.
\item Either a 'showgame' or 'showscores' HTML document.
\item A show number character starting with "#".
\item An air date like "yyyy-mm-dd".
}}
}
\value{
Tidy tibble of clue scores.
}
\description{
\emph{This} data describes how players performed over the course of a game.
}
\examples{
whatr_scores(game = 6304)
}
