% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.R
\name{BottomLeftOf}
\alias{BottomLeftOf}
\title{Bottom left of}
\usage{
BottomLeftOf(x = NULL, just = c("right", "bottom"), v.pad = 0,
  h.pad = 0)
}
\arguments{
\item{x}{target object, either a name, a object or NULL which refers to the last plotting object}

\item{just}{the part from the new object that should be attached to}

\item{v.pad}{vertical translational padding [0.0]}

\item{h.pad}{horizontal translational padding [0.0]}
}
\value{
a WDimGenerator
}
\description{
Place a new object to the bottom left corner of another.
}
\examples{
WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomLeftOf(just=c('right','top')))

WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomLeftOf(just=c('right','bottom')))

WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WHeatmap(matrix(c(rnorm(100)+1,rnorm(100)), nrow=10),
    cmp=CMPar(brewer.name = 'RdGy'), BottomLeftOf(just=c('left','bottom')))
}
