% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whibo_clustering.R
\name{predict.whibo_cluster}
\alias{predict.whibo_cluster}
\title{Predict to which Cluster new data belongs}
\usage{
\method{predict}{whibo_cluster}(object, data, ...)
}
\arguments{
\item{object}{WhiBo Cluster model.}

\item{data}{Data for which Cluster should be obtained.}

\item{...}{None of those will be used.}
}
\value{
Vector of assignments.
}
\description{
Predict to which Cluster new data belongs
}
\examples{
data <- iris[1:100, 1:4] #Numerical data only and first 100 rows

model <- whibo_clustering(data = data, k = 3)
predict(object = model, data = iris[101:150, 1:4])

}
\author{
Sandro Radovanovic \email{sandro.radovanovic@gmail.com}
}
