% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_river_centerlines}
\alias{wbt_river_centerlines}
\title{River centerlines}
\usage{
wbt_river_centerlines(
  input,
  output,
  min_length = 3,
  radius = 4,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input raster image file.}

\item{output}{Name of the output vector lines file.}

\item{min_length}{Minimum line length, in grid cells.}

\item{radius}{Search radius for joining distant endnodes, in grid cells.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Maps river centerlines from an input water raster.
}
\keyword{HydrologicalAnalysis}
