% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_board.R
\name{show_board}
\alias{show_board}
\title{Display game board representation}
\usage{
show_board(paths = NULL, hideouts = NULL, roads, alley, node_locations)
}
\arguments{
\item{paths}{optional list of all possible paths already traveled}

\item{hideouts}{optional vector of possible hideouts from previous rounds.}

\item{roads}{data.frame of non-directional edge pairs for the road graph}

\item{alley}{data.frame of non-directional edge pairs for the alley graph}

\item{node_locations}{data.frame of where nodes should be placed in the graph}
}
\value{
plotted igraph object
}
\description{
Show a graph representation of the game board with nodes placed in the appropriate relative spot, colored by the number of paths which include a particular node. Possible hideouts are marked with blue squares.
}
\details{
roads, alley and node_locations are all bundled with the package (e.g. \code{data(roads)}).
Solid lines in the graph represent road connections between nodes. Dashed lines represent alley way connections.
}
\examples{
possibilities = start_round(64)
possibilities = take_a_step(possibilities,roads)
possibilities = take_a_step(possibilities,roads,blocked=list(c(63,82),c(63,65)))
possibilities = take_a_step(possibilities,alley)
show_board(paths=possibilities,hideouts=NULL,roads,alley,node_locations)
}
