% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widgetframe.R
\name{frameableWidget}
\alias{frameableWidget}
\title{Adds pymjs initialization code to a htmlwidget.}
\usage{
frameableWidget(widget, renderCallback = NULL)
}
\arguments{
\item{widget}{The widget to add the pymjs code to.}

\item{renderCallback}{An optional Javascript function wrapped in \code{\link[htmlwidgets]{JS}()} which will be called when parent sends a resize event.}
}
\description{
This function augments a htmlwidget so that when saved,
the resulting HTML document can be rendered correctly inside a responsive iframe
(created using \href{http://blog.apps.npr.org/pym.js/}{Pym.js}) of another HTML document.
}
\details{
Generate your htmlwidget in the normal way and then call this function
passing in your widget. Then call \code{\link[htmlwidgets]{saveWidget}()} and the saved HTML file is now embeddable inside a Pym.js iframe of another HTML document. See \href{http://blog.apps.npr.org/pym.js/}{Pym.js} documentation on how to create an HTML document with a responsive iframe.
}
\examples{
\dontrun{
library(leaflet)
l <- leaflet() \%>\% addTiles() \%>\% setView(0,0,1)
htmlwidgets::saveWidget(
  widgetframe::frameableWidget(l),'some-directory-on-your-disk')
}
}
\seealso{
\code{\link{frameWidget}()}.
}
