\name{wpgraphs}
\alias{wpgraphs}
\title{Wild Poker Graphs for Best Hand Analysis}
\description{This function presents an array of graphs which indicate how hand types compare for
a given wild poker variant.}
\usage{wpgraphs(gstat, ngame = NULL, players = NULL, wcnum = NULL, stats = FALSE)}
\arguments{
  \item{gstat}{a gstat (graph stats) object generated by the \code{\link{wpstats}} function.  If
this parameter exists, ngame, players and wcnum are not used.} 

  \item{ngame}{ This is any supported game, such as "Seven Card Stud" or "Baseball". See
    \code{\link{wpsupportedgames}}.}

  \item{players}{An integer value, must be at least 2 and is limited by the number
    of cards that can be physically dealt.  (eg, Seven Card Stud has a max of 7 players)}

  \item{wcnum}{A standardized set of wildcard combinations, valid values are 0:7.  
unlike the wcard parameter in \code{wpgame} and \code{wpstats}, each numeric value matches
one and only one set of wildcards:
    \itemize{
      \item \code{0 = no wildcards}	
      \item \code{1 = "Suicide King" aka "KH"}	
      \item \code{2 = "One Eyed Jacks" aka c("JH", "JS")}   
      \item \code{3 = c("Suicide King", "One Eyed Jacks")}	
      \item \code{4 = "Deuces" aka c("2H", "2C", "2D", "2S")}	
      \item \code{5 = c("Deuces", "Suicide King")}	
      \item \code{6 = c("Deuces", "One Eyed Jacks")}   
      \item \code{7 = c("Deuces", "Suicide King", "One Eyed Jacks")}
    }}
  \item{stats}{if TRUE, return the gstat list instead of generating graphs}
}
\details{This function either accepts input from \code{wpstats} or more typically matches game variant
details (ngame, players, wcnum) to pre-calculated gstat lists.  All supported game combinations with
0-7 wildcards and 2-8 players (or less if 8 players aren't possible) have been precalculated.

Precisely what is graphed depends on whether the game has split hands or not, and the graphic device needs
a sufficiently large window to show a 4x4 array of graphs with reasonable detail.
}
\value{
if stats = TRUE, prints the gstat list - either gstat parameter, or the precalculated
gstat object queried by the ngame, player and wcnum combination.

if stats = FALSE, generates a 4x4 graph array.

\item{Example1}{Precalculated variant with emergent wildcards and main hand only:

  \code{wpgraphs(ngame = "Follow the Queen", players = 6, wcnum = 1)}

  \if{html}{\figure{graphftq.png}}

}

\item{Example2}{Custom variant with split hand and nonstandard win conditions:

  \code{wpgraphs(wpstats("High Chicago", 4, "Dr Pepper", numdeal = 10, seed = 100))}

  \if{html}{\figure{graphhcdp.png}}

}}     


\references{\href{http://www.poker.com/game/index.htm}{poker.com} has an excellent reference on game variants which was the 
primary source for games rules not encountered in my own play.}

\note{This function is the primary point of the wildpoker package, intended to allow a user to rapidly
evaluate the way hands change in value as wildcards, players or game variants change.}

\author{Maintainer: Bradley Shanrock-Solberg  
        \email{greblosb@gmail.com}}

\seealso{\code{\link{wpstats}}}  

\examples{
# These examples show the gstat output option.  For the graphs of these examples,
# see \bold{value} section, above.
#
# example of normal wpgraphs use.
wpgraphs(ngame = "Follow the Queen", players = 6, wcnum = 1, stats = TRUE)

# example of using wpstats to generate a nonstandard combination
# note that if a gstat object is provided (by wpstats), the ngame, players, wcnum aren't used 
wpgraphs(wpstats("High Chicago", 4, "Dr Pepper", numdeal = 10, seed = 100), stats = TRUE)

} 