% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_climate.R
\name{filter_coverage}
\alias{filter_coverage}
\title{Filter stations based on "coverage" requirements.}
\usage{
filter_coverage(coverage_df, coverage = 0)
}
\arguments{
\item{coverage_df}{A dataframe as returned by the \code{meteo_coverage}
function in the \code{rnoaa} package}

\item{coverage}{A numeric value in the range of 0 to 1 that specifies
the desired percentage coverage for the weather variable (i.e., what
percent of each weather variable must be non-missing to include data from
a monitor when calculating daily values averaged across monitors).}
}
\value{
A dataframe with stations that meet the specified coverage
   requirements for weather variables included in the \code{coverage_df}
   dataframe passed to the function.
}
\description{
Filters available weather stations based on a specified required minimum
coverage (i.e., percent non-missing daily observations). Weather stations
with non-missing data for fewer days than specified by \code{coverage} will
be excluded from the county average.
}
