% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orNumeric.R
\name{orNumeric}
\alias{orNumeric}
\title{orNumeric module server logic}
\usage{
orNumeric(input, output, session, choices, value, label = "Column",
  step = 100, stepsize = NULL,
  min. = shiny::reactive(min(choices_r(), na.rm = TRUE)),
  max. = shiny::reactive(max(choices_r(), na.rm = TRUE)),
  label.slider = NULL, zoomable = TRUE, reset = NULL)
}
\arguments{
\item{input}{Shiny's input object.}

\item{output}{Shiny's output object.}

\item{session}{Shiny's session object.}

\item{choices}{A list or a numeric vector with the possible choices offered in the UI. See \code{\link[shiny]{sliderInput}} (Supports reactive).}

\item{value}{Initial value of the slider. Creates a ranged slider if numeric vector of two given (Supports reactive).}

\item{label}{Label of the entire module.}

\item{step}{Number of steps on interval (Default = 100).}

\item{stepsize}{Value defining interval size of the slider. Will be used instead of step (Default = NULL).}

\item{min.}{Minimum value that can be selected on slider (defaults to min(choices)) (Supports reactive).}

\item{max.}{Maximum value that can be selected on slider (defaults to max(choices)) (Supports reactive).}

\item{label.slider}{A character vector of length one with the label for the \code{\link[shiny]{sliderInput}}.}

\item{zoomable}{Boolean to enable zooming. Redefine the sliders range. Defaults to TRUE.}

\item{reset}{A reactive which will trigger a module reset on change.}
}
\value{
Returns a reactive containing a named list with the label, the selected choices as a character vector (text), a boolean vector of length \code{length(choices)} (bool), and a vector of the selected value(s) (value), indicating whether a item has been chosen. If no item has been chosen, the return is \code{TRUE} for items.
}
\description{
Provides server logic for the orNumeric module.
}
