% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitness.R
\name{fitness}
\alias{fitness}
\title{Evaluate the Individual Fitness values}
\usage{
fitness(selection, referenceHeight, RotorHeight, SurfaceRoughness, Polygon,
  resol1, rot, dirspeed, srtm_crop, topograp, cclRaster, weibull, Parallel,
  numCluster)
}
\arguments{
\item{selection}{A list containing all individuals of the current population.}

\item{referenceHeight}{The height at which the incoming wind speeds were
measured.}

\item{RotorHeight}{The desired height of the turbine.}

\item{SurfaceRoughness}{A surface roughness length of the considered area in
m.}

\item{Polygon}{The considered area as shapefile.}

\item{resol1}{The resolution of the grid in meter.}

\item{rot}{The desired rotor radius in meter.}

\item{dirspeed}{The wind data as list.}

\item{srtm_crop}{A list of 3 raster, with 1) the elevation, 2) an orographic
and 3) a terrain raster. Calculated in \code{\link{genetic_algorithm}}}

\item{topograp}{Logical value that indicates whether the terrain effect model
is activated (TRUE) or deactivated (FALSE).}

\item{cclRaster}{A Corine Land Cover raster, that has to be adapted
previously by hand with the surface roughness length for every land cover
type. Is only used, when the terrain effect model is activated.}

\item{weibull}{A raster representing the estimated wind speeds}

\item{Parallel}{Boolean value, indicating whether parallel processing should
be used. The parallel and doParallel packages are used for parallel
processing.}

\item{numCluster}{If Parallel is TRUE, this variable defines the number of
clusters to be used.}
}
\value{
Returns a list with every individual, consisting of X & Y
  coordinates, rotor radii, the runs and the selected grid cell IDs, and the
  resulting energy outputs, efficiency rates and fitness values.
}
\description{
The fitness values of the individuals in the current population
  are calculated after having evaluated their energy outputs in
  \code{\link{calculate_energy}}. This function reduces the resulting energy
  outputs to a single fitness value for every individual.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                    c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)

## Create a uniform and unidirectional wind data.frame and plots the
## resulting wind rose
## Uniform wind speed and single wind direction
wind <- data.frame(ws = 12, wd = 0)
# windrosePlot <- plot_windrose(data = wind, spd = wind$ws,
#                dir = wind$wd, dirres=10, spdmax=20)

## Calculate a Grid and an indexed data.frame with coordinates and
## grid cell IDs.
Grid1 <- grid_area(shape = Polygon1,resol = 200,prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

wind <- list(wind, probab = 100)
startsel <- init_population(Grid,10,20);
fit <- fitness(selection = startsel, referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20,
               dirspeed = wind, srtm_crop="", topograp=FALSE, cclRaster="",
               Parallel = FALSE)
}
}
\seealso{
Other Genetic Algorithm Functions: \code{\link{crossover}},
  \code{\link{genetic_algorithm}},
  \code{\link{init_population}}, \code{\link{mutation}},
  \code{\link{selection}}, \code{\link{trimton}},
  \code{\link{windfarmGA}}
}
\concept{Genetic Algorithm Functions}
