% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{splitAt}
\alias{splitAt}
\title{Split matrices or numeric vectors at specific indices}
\usage{
splitAt(x, pos)
}
\arguments{
\item{x}{A numeric variable that represents an individual's 
binary genetic code}

\item{pos}{A numeric value that indicates where to split the genetic code}
}
\value{
Returns a list of the split genetic code.
}
\description{
The function is used by the crossover method to
split a genetic code at certain intervals. See also \code{\link{crossover}}.
}
\examples{
splitAt(1:100, 20)
splitAt(as.matrix(1:100), 20)

}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getDEM}()},
\code{\link{getISO3}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{hexa_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
