% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd-handle.R
\name{wk_handle.wk_grd_xy}
\alias{wk_handle.wk_grd_xy}
\alias{wk_handle.wk_grd_rct}
\title{Handler interface for grid objects}
\usage{
\method{wk_handle}{wk_grd_xy}(handleable, handler, ..., data_order = c("y", "x"))

\method{wk_handle}{wk_grd_rct}(handleable, handler, ..., data_order = c("y", "x"))
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{data_order}{A vector of length 2 describing the order in which
values should appear. The default, \code{c("y", "x")}, will output values
in the same order as the default matrix storage in R (column-major).
You can prefix a dimension with \code{-} to reverse the order of a
dimension (e.g., \code{c("-y", "x")}).}
}
\value{
The result of the \code{handler}.
}
\description{
Handler interface for grid objects
}
\examples{
wk_handle(grd(nx = 3, ny = 3), wkt_writer())
wk_handle(grd(nx = 3, ny = 3, type = "centers"), wkt_writer())

}
