% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateFromWeek.R
\name{dateFromWeek}
\alias{dateFromWeek}
\title{Return the dates of a particular week}
\usage{
dateFromWeek(year, wkIndex, wkMethod = "ISO")
}
\arguments{
\item{year}{a value for the year.}

\item{wkIndex}{a value for the week index of the year.}

\item{wkMethod}{a character string for the week-counting method.
Default is "ISO" for ISO-week;
other options are "epiSat", "epiSun" and "epiMon" for epi-week method
defining Saturday, Sunday and Monday as the firstday in a week, respectively.}
}
\value{
a vector of length 7, containing all the dates in the week, with the format
  of yyyy-mm-dd.
}
\description{
Returns the dates of a particular week.
  The week can be defined by ISO week or epi week.
}
\examples{
dateFromWeek(year = 2000, wkIndex = 20)
dateFromWeek(year = 2009, wkIndex = 53)
dateFromWeek(year = 2015, wkIndex = 1, wkMethod = "epiSun")
}
\seealso{
weekToMonth
}
\author{
You Li
}
