% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woe.binning.plot.R
\name{woe.binning.plot}
\alias{woe.binning.plot}
\title{Visualization of Binning}
\usage{
woe.binning.plot(binning, multiple.plots, plot.range)
}
\arguments{
\item{binning}{Binning information generated from the \code{woe.binning} or \code{woe.tree.binning} function.
Contains names of the input predictor variables and the
corresponding binning, WOE and IV information, which is used to
generate the WOE and IV plots.}

\item{multiple.plots}{In case the binning solution contains several predictor variables they will
be visualized via multiple plots (max. four WOE plots per graph window).
Use \emph{multiple.plots=FALSE} to avoid this and to display single plots in
separate windows.}

\item{plot.range}{Range of variables that should be plotted in quotes. For example \dQuote{1:10}
will generate WOE plots and one IV plot for the ten variables with the
highest IV values, \dQuote{11:20} for the next ten variables and so on.
Just omit this parameter to visualize all binned variables (default).}
}
\description{
\code{woe.binning.plot} visualizes the binning solution generated and saved via the \code{\link{woe.binning}}
or \code{\link{woe.tree.binning}} function.
}
\details{
For each predictor variable \code{woe.binning.plot} generates a weight of evidence
(WOE) plot. In case of multiple predictors an additional plot with variables ranked
via the information value (IV) will be displayed.
}
\examples{
# Load German credit data
data(germancredit)
df <- germancredit

# Bin all variables of the data frame (apart from the target variable)
# with default parameter settings
binning <- woe.binning(df, 'creditability', df)

# Plot all binned variables as multiple plots
woe.binning.plot(binning)

# Plot only the first four binned variables with the highest IV value
# as multiple plots
woe.binning.plot(binning, plot.range='1:4')

# Plot the binned variables in single plots
woe.binning.plot(binning, multiple.plots=FALSE)

}
