% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-wp-tags.R
\name{update_wp_tag}
\alias{update_wp_tag}
\title{Update a WordPress Tag Page}
\usage{
update_wp_tag(
  domain,
  user,
  pass,
  tag_id,
  tag_name,
  tag_slug,
  tag_description,
  verbose = TRUE
)
}
\arguments{
\item{domain}{The domain on which you wish to update the given tag.}

\item{user}{The username to be passed into the API call to update the tag.}

\item{pass}{The password to be used in the API call to update the tag.
To get this value, you must have the Application Passwords plugin
installed, and must create an application using that plugin via your WordPress
admin panel; there you will get the password needed.}

\item{tag_id}{The ID of the category desired to be updated in the WordPress
site's database.}

\item{tag_name}{The desired name of the tag that users will see on
the WordPress site.}

\item{tag_slug}{The slug to be associated with the WordPress category.
Change with caution, as changing the slug may result in URLs being broken.}

\item{tag_description}{The description of the tag; this value will be used wherever
the description of the WordPress category is used (perhaps in your theme).}

\item{verbose}{Defaults to TRUE; determines whether or not the desired tag name and
slug will be printed in the console. Potentially useful if employing this function in
a loop in which many tags will be updated at once.}
}
\value{
response from the API. 200 means success -- the tag was updated!
}
\description{
Update the name, description, or slug of a tag in your WordPress site.
}
\examples{
\dontrun{
update_wp_tag(root_url = 'https://domain.com',user = Sys.getenv('username'),
pass = Sys.getenv('password'), tag_name = 'cool posts',
description_text = 'this is the description text for the tag "very cool posts". ')
}

}
