% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_quickstart.R
\name{wflow_quickstart}
\alias{wflow_quickstart}
\title{Quickly start a workflowr project}
\usage{
wflow_quickstart(files, username, supporting_files = NULL,
  directory = NULL, change_wd = TRUE, delete_on_error = TRUE,
  view = getOption("workflowr.view"), git.user.name = NULL,
  git.user.email = NULL, host = c("github", "gitlab"),
  create_on_github = NULL)
}
\arguments{
\item{files}{character. The R Markdown file(s) to be copied into the
subdirectory \code{analysis/} of the newly created workflowr project. If
the argument \code{directory} is left as \code{NULL}, the workflowr project
will be named after the first Rmd file. This new directory will be located
in the current working directory. Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.}

\item{username}{character (default: NULL). The GitHub or GitLab account you
want to use to create the remote Git repository. This is likely your
personal username, but it could also be the name of an organization you
belong to.}

\item{supporting_files}{character (default: NULL) Supporting files or
directories that are used by the Rmd files. These will be copied to the
root of the project. Since by default Rmd files are executed in the root of
the project, any relative file paths should still work. Long term it is
recommended to move these supporting files to subdirectories of the
workflowr project, e.g. \code{data/}.}

\item{directory}{character (default: NULL). The path to the directory to
create the workflowr project. This directory will also be used to name the
remote Git repository. If left as \code{NULL}, the name is derived from the
first Rmd file that is passed to the argument \code{files}.}

\item{change_wd}{logical (default: TRUE). Change the working directory to
the newly created workflowr project. Passed to \code{\link{wflow_start}}.}

\item{delete_on_error}{logical (default: TRUE). Delete the newly created
project if any error occurs.}

\item{view}{logical (default: \code{getOption("workflowr.view")}). View the
local website after it is built (will open the home page in the RStudio
Viewer pane or your web browser).}

\item{git.user.name}{character (default: \code{NULL}). The user name
used by Git to sign commits, e.g., "Ada Lovelace". This setting
only applies to the workflowr project being created. To specify the
global setting for the Git user name, use
\code{\link{wflow_git_config}} instead. When \code{user.name =
NULL}, no user name is recorded for the project, and the global
setting will be used. This setting can be modified later
by running \code{git config --local} in the Terminal.}

\item{git.user.email}{character (default: \code{NULL}). The email
address used by Git to sign commits, e.g.,
"ada.lovelace@ox.ac.uk". This setting only applies to the workflowr
project being created. To specify the global setting for the Git
email address, use \code{\link{wflow_git_config}} instead. When
\code{user.name = NULL}, no email address is recorded for the
project, and the global setting will be used. This setting can be
modified later by running \code{git config --local} in the Terminal.}

\item{host}{character. Choose the service for hosting the Git repository.
Must be either "github" for GitHub.com or "gitlab" for GitLab.com.}

\item{create_on_github}{logical (default: NULL). Should workflowr create the
repository on GitHub? This requires logging into your GitHub account to
authenticate workflowr to act on your behalf. The default behavior is to
ask the user. Note that this only works for public repositories on
github.com. If you want to create a private repository or are using GitHub
Enterprise, you will need to manually create the repository.}
}
\value{
Invisibly returns the absolute path to the newly created workflowr
  project.
}
\description{
\code{wflow_quickstart} provides a simple interface to effortlessly create a
workflowr project from an existing data analysis.
}
\details{
\code{wflow_quickstart} performs the following steps:

\itemize{

\item Starts a new project with \code{\link{wflow_start}}

\item Copies the Rmd file(s) to the subdirectory \code{analysis/}

\item Copies the supporting file(s) and/or directory(s) to the root of the
 project (Note: by default Rmd files are executed in the root of the project,
 so relative file paths should still work)

\item Adds link(s) to the results to the main index page

\item Publishes the Rmd files with \code{\link{wflow_publish}}

\item Configures the remote repository with \code{\link{wflow_use_github}} or
\code{\link{wflow_use_gitlab}}

}

Once it has completed, you can push to the remote service with
\code{\link{wflow_git_push}}. Alternatively you can run \code{git push} in the
terminal.

If you are using GitHub and you chose to not allow workflowr to create the
repository for you, then you will have to login to your account and create
the new repository yourself. If you're using GitLab, you don't have to worry
about this because the new repository will be automatically created when you
push.
}
\examples{
\dontrun{

wflow_quickstart(files = "existing-analysis.Rmd", username = "your-github-username")
}

}
\seealso{
\link{workflowr}, \code{\link{wflow_start}}, \code{\link{wflow_publish}},
         \code{\link{wflow_use_github}}, \code{\link{wflow_use_gitlab}},
         \code{\link{wflow_git_push}}
}
