% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom.R
\name{augment.workflow}
\alias{augment.workflow}
\title{Augment data with predictions}
\usage{
\method{augment}{workflow}(x, new_data, ...)
}
\arguments{
\item{x}{A workflow}

\item{new_data}{A data frame of predictors}

\item{...}{Arguments passed on to methods}
}
\value{
\code{new_data} with new prediction specific columns.
}
\description{
This is a \code{\link[generics:augment]{generics::augment()}} method for a workflow that calls
\code{augment()} on the underlying parsnip model with \code{new_data}.

\code{x} must be a trained workflow, resulting in fitted parsnip model to
\code{augment()} with.

\code{new_data} will be preprocessed using the preprocessor in the workflow,
and that preprocessed data will be used to generate predictions. The
final result will contain the original \code{new_data} with new columns containing
the prediction information.
}
\examples{
if (rlang::is_installed("broom")) {

library(parsnip)
library(magrittr)
library(modeldata)

data("attrition")

model <- logistic_reg() \%>\%
  set_engine("glm")

wf <- workflow() \%>\%
  add_model(model) \%>\%
  add_formula(
    Attrition ~ BusinessTravel + YearsSinceLastPromotion + OverTime
  )

wf_fit <- fit(wf, attrition)

augment(wf_fit, attrition)

}
}
