% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{wb_income_level}
\alias{wb_income_level}
\title{World Bank income level data}
\source{
\url{http://api.worldbank.org/v2/incomeLevels}
}
\usage{
wb_income_level(income = NULL, lang = "en")
}
\arguments{
\item{income}{\code{character()} income level to query. Default \code{NULL}.
If \code{NULL}, all levels are returned.}

\item{lang}{\code{character(1)} language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available income levels. The columns are:
\item{id}{The income level ID.}
\item{iso2code}{The ISO 2 code of the income level.}
\item{value}{The income level value.}
}
\description{
List all income levels supported by the World Bank API.
}
\examples{
wb_income_level()
}
