% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fotmob_matches.R
\name{fotmob_get_matches_by_date}
\alias{fotmob_get_matches_by_date}
\title{Get fotmob match results by date}
\usage{
fotmob_get_matches_by_date(dates)
}
\arguments{
\item{dates}{a vector of string-formatted dates in "Ymd" format, e.g. "20210926". An attempt is
made to coerce the input to the necessary format if a date is passed in.}
}
\value{
returns a dataframe of match results
}
\description{
Returns match results for all matches played on the selected date from fotmob.com
}
\examples{
\dontrun{
library(dplyr)
library(tidyr)

results <- fotmob_get_matches_by_date(date = c("20210925", "20210926"))
results \%>\%
  dplyr::select(primaryId, ccode, league_name = name, matches) \%>\%
  tidyr::unnest_longer(matches)
}

}
