% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_match_urls.R
\name{get_match_urls}
\alias{get_match_urls}
\title{Get match URLs}
\usage{
get_match_urls(
  country,
  gender,
  season_end_year,
  tier = "1st",
  non_dom_league_url = NA
)
}
\arguments{
\item{country}{the three character country code}

\item{gender}{gender of competition, either "M" or "F", or both}

\item{season_end_year}{the year the season(s) concludes}

\item{tier}{the tier of the league, ie '1st' for the EPL or '2nd' for the Championship and so on}

\item{non_dom_league_url}{the URL for Cups and Competitions found at https://fbref.com/en/comps/}
}
\value{
returns a character vector of all fbref match URLs for selected competition, season and gender
}
\description{
Returns the URL for each match played for a given league season
}
\examples{
\donttest{
get_match_urls(country = "ENG", gender = "M", season_end_year = c(2019:2021), tier = "1st")
non_dom <- "https://fbref.com/en/comps/218/history/Friendlies-M-Seasons"
get_match_urls(country = "", gender = "M", season_end_year = 2021, non_dom_league_url = non_dom)
}
}
