% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_match_results.R
\name{get_match_results}
\alias{get_match_results}
\title{Get match results}
\usage{
get_match_results(
  country,
  gender,
  season_end_year,
  tier = "1st",
  non_dom_league_url = NA
)
}
\arguments{
\item{country}{the three character country code}

\item{gender}{gender of competition, either "M" or "F"}

\item{season_end_year}{the year(s) the season concludes}

\item{tier}{the tier of the league, ie '1st' for the EPL or '2nd' for the Championship and so on}

\item{non_dom_league_url}{the URL for Cups and Competitions found at https://fbref.com/en/comps/}
}
\value{
returns a dataframe with the results of the competition, season and gender
}
\description{
Returns the game results for a given league season(s)
}
\examples{
\dontrun{
try({
df <- get_match_results(country = c("ITA"), gender = "M", season_end_year = 2021)
# for results from English Championship:
df <- get_match_results(country = "ENG", gender = "M", season_end_year = 2021, tier = "2nd")
# for international friendlies:

})
}
}
