% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_line_asis.R
\name{create_line_asis}
\alias{create_line_asis}
\title{Create a line chart without aggregation for any metric}
\usage{
create_line_asis(
  data,
  date_var = "Date",
  metric,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab = date_var,
  xlab = metric,
  line_colour = rgb2hex(0, 120, 212)
)
}
\arguments{
\item{data}{Plotting data as a data frame.}

\item{date_var}{String containing name of variable for the horizontal axis.}

\item{metric}{String containing name of variable representing the line.}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{ylab}{Y-axis label for the plot (group axis)}

\item{xlab}{X-axis label of the plot (bar axis).}

\item{line_colour}{String to specify colour to use for the line.
Hex codes are accepted. You can also supply
RGB values via \code{rgb2hex()}.}
}
\value{
Returns a 'ggplot' object representing a line plot.
}
\description{
This function creates a line chart directly from the aggregated / summarised data.
Unlike \code{create_line()} which performs a person-level aggregation, there is no
calculation for \code{create_line_asis()} and the values are rendered as they are passed
into the function. The only requirement is that a \code{date_var} is provided for the x-axis.
}
\examples{
library(dplyr)

# Median `Emails_sent` grouped by `Date`
# Without Person Averaging
med_df <-
  sq_data \%>\%
  group_by(Date) \%>\%
  summarise(Emails_sent_median = median(Emails_sent))

med_df \%>\%
  create_line_asis(
    date_var = "Date",
    metric = "Emails_sent_median",
    title = "Median Emails Sent",
    subtitle = "Person Averaging Not Applied",
    caption = extract_date_range(sq_data, return = "text")
  )

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_network_plot}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Flexible: 
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_hist}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}

Other Time-series: 
\code{\link{IV_by_period}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}
}
\concept{Flexible}
\concept{Time-series}
\concept{Visualization}
