% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asSepList.R
\name{asSepList}
\alias{asSepList}
\title{Organize data as separate list-entries}
\usage{
asSepList(y, asNumeric = TRUE, minLen = 4, fxArg = NULL,
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{y}{list to be separated/split in vectors}

\item{asNumeric}{(logical) to transform all list-elements in simple numeric vectors (won't work if some entries are character)}

\item{minLen}{(integer) (currently use of this argument not implemeneted!) min length (or number of rows), as add'l element to eliminate arguments given wo names when asSepList is called in vioplot2}

\item{fxArg}{(character) optinal names to exclude if any (lazy matching) matches (to exclude other arguments be misinterpreted as data, used in wrGraph::vioplot2)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list, partially unlisted to vectors
}
\description{
\code{asSepList} allows reorganizing list into separate numeric vectors. For example, matrixes or data.frames will be split into separate columns 
(differnt to \code{\link[wrMisc]{partUnlist} which maintains the original structure}. This function also works with lists of lists.
This function may be helpful for reorganizing data for plots.
}
\examples{
bb <- list(fa=gl(2,2),c=31:33,L2=matrix(21:24,nc=2),li=list(li1=11:14,li2=data.frame(41:44)))
asSepList(bb)
lapply(bb,.asDF2)
partUnlist(lapply(bb,.asDF2))
}
\seealso{
\code{\link[wrMisc]{partUnlist}}, \code{\link[base]{unlist}}
}
