% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partUnlist.R
\name{partUnlist}
\alias{partUnlist}
\title{Partial unlist of lists of lists}
\usage{
partUnlist(lst, sep = "_", silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{lst}{(list) main input, list to be partially unlisted}

\item{sep}{(character, length=1) separator for names}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with partially reduced nested structure
}
\description{
\code{partUnlist} does partial unlist for treating list of lists : New (returned) list has one level less of hierarchy 
(Highest level list will be appended). In case of conflicting (non-null) listnames a prefix will be added. 
Behaviour different to \code{\link[base]{unlist}} when unlisting list of matrixes.
}
\examples{
partUnlist(list(list(a=11:12,b=21:24), list(c=101:101,d=201:204)))
li4 <- list(c=1:3, M2=matrix(1:4,ncol=2), L3=list(L1=11:12, M3=matrix(21:26,ncol=2)))
partUnlist(li4)
unlist(li4, rec=FALSE)
}
\seealso{
\code{\link[base]{unlist}}, \code{\link{asSepList}}
}
