% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleXY.R
\name{scaleXY}
\alias{scaleXY}
\title{Scale data to given minimum and maxiumum}
\usage{
scaleXY(x, min = 0, max = 1)
}
\arguments{
\item{x}{(numeric) vector to rescacle}

\item{min}{(numeric) minimum value in output}

\item{max}{(numeric) maximum value in output}
}
\value{
vector of rescaled data (in dimensions as input)
}
\description{
This is a convenient way to scale data to given minimum and maxiumum without full standarization, ie without deviding by the sd.
}
\examples{
dat <- matrix(2*round(runif(100),2), ncol=4)
range(dat)
dat1 <- scaleXY(dat, 1,100)
range(dat1)
summary(dat1)

## scale for each column individually
dat2 <- apply(dat, 2, scaleXY, 1, 100)
range(dat2)
summary(dat2)
}
\seealso{
\code{\link[base]{scale}}
}
