% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naOmit.R
\name{naOmit}
\alias{naOmit}
\title{Fast na.omit}
\usage{
naOmit(x)
}
\arguments{
\item{x}{(vector or matrix) input}
}
\value{
vector without NAs (matrix input will be transformed to vector). Returns NULL if input consists only of NAs.
}
\description{
\code{naOmit} removes NAs from input vector. This function has no slot for removed elements while \code{na.omit} does so. 
Resulting objects from \code{naOmit} are smaller in size and subsequent execution (on large vectors) is faster (in particular if many NAs get encountered).
Note : Behaves differently to \code{na.omit} with input other than plain vectors. Will not work with data.frames !
}
\examples{
aA <- c(11:13,NA,10,NA); 
naOmit(aA) 
}
\seealso{
\code{\link[stats]{na.fail}}, \code{na.omit}
}
