% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeSampleInList.R
\name{removeSampleInList}
\alias{removeSampleInList}
\title{Remove samples/columns from list of matrixes
  
Remove samples (ie columns) from every instance of list of matrixes.
Note: This function assumes same order of columns in list-elements 'listElem' !}
\usage{
removeSampleInList(
  dat,
  remSamp,
  listElem = c("abund", "quant"),
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(list) main input to be filtered}

\item{remSamp}{(integer) column number to exclude}

\item{listElem}{(character) names of list-elements where columns indicated with 'remSamp' should be removed}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
matrix including imputed values or list of final and matrix with number of imputed by group (plus optional plot)
}
\description{
Remove samples/columns from list of matrixes
  
Remove samples (ie columns) from every instance of list of matrixes.
Note: This function assumes same order of columns in list-elements 'listElem' !
}
\examples{
set.seed(2019)
datT6 <- matrix(round(rnorm(300)+3,1),ncol=6,dimnames=list(paste("li",1:50,sep=""),
  letters[19:24]))
datL <- list(abund=datT6,quant=datT6,annot=matrix(nrow=nrow(datT6),ncol=2)) 
datDelta2 <- removeSampleInList(datL,remSam=2)
}
\seealso{
\code{\link{testRobustToNAimputation}}
}
