% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{wa_cache_clear}
\alias{wa_cache_clear}
\title{Clear writeAlizer's user cache}
\usage{
wa_cache_clear(ask = interactive(), preview = TRUE)
}
\arguments{
\item{ask}{Logical; if \code{TRUE} and interactive, ask for confirmation.}

\item{preview}{Logical; if \code{TRUE} and \code{ask} is \code{TRUE}, show a brief
listing/size summary before asking.}
}
\value{
Invisibly returns \code{TRUE} if the cache was cleared (or already absent),
  \code{FALSE} if the user declined or deletion failed.
}
\description{
Deletes all files under \code{wa_cache_dir()}. If \code{ask = TRUE} \emph{and} in an
interactive session, a short preview (item count, total size, and up to 10 sample
paths) is printed before asking for confirmation.
}
\examples{
# Safe demo: redirect cache to tempdir(), create a file, then clear it
\dontshow{
old <- getOption("writeAlizer.cache_dir"); on.exit(options(writeAlizer.cache_dir = old), add = TRUE)
tmp <- file.path(tempdir(), "wa_cache_demo2"); dir.create(tmp, recursive = TRUE, showWarnings = FALSE)
options(writeAlizer.cache_dir = tmp)
writeLines("demo", file.path(wa_cache_dir(), "demo.txt"))
wa_cache_clear(ask = FALSE)
}
}
\seealso{
\code{\link{wa_cache_dir}}
}
