% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_geo_api.R
\name{census_geo_api}
\alias{census_geo_api}
\title{Census Data download function.}
\usage{
census_geo_api(
  key = Sys.getenv("CENSUS_API_KEY"),
  state,
  geo = c("tract", "block", "block_group", "county", "place", "zcta"),
  age = FALSE,
  sex = FALSE,
  year = c("2020", "2010"),
  retry = 3,
  save_temp = NULL,
  counties = NULL
)
}
\arguments{
\item{key}{A character string containing a valid Census API key,
which can be requested from the
\href{https://api.census.gov/data/key_signup.html}{U.S. Census API key signup page}.

By default, attempts to find a census key stored in an
\link[=Sys.getenv]{environment variable} named \code{CENSUS_API_KEY}.}

\item{state}{A required character object specifying which state to extract Census data for,
e.g., \code{"NJ"}.}

\item{geo}{A character object specifying what aggregation level to use.
Use \code{"block"}, \code{"block_group"}, \code{"county"}, \code{"place"}, \code{"tract"}, or \code{"zcta"}.
Default is \code{"tract"}. Warning: extracting block-level data takes very long.}

\item{age}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
age or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Age | Race).
If \code{\var{sex}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{sex}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
sex or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Sex | Race).
If \code{\var{age}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{year}{A character object specifying the year of U.S. Census data to be downloaded.
Use \code{"2010"}, or \code{"2020"}. Default is \code{"2020"}.
Warning: 2020 U.S. Census data is downloaded only when \code{\var{age}} and
\code{\var{sex}} are both \code{FALSE}.}

\item{retry}{The number of retries at the census website if network interruption occurs.}

\item{save_temp}{File indicating where to save the temporary outputs.
Defaults to NULL. If specified, the function will look for an .RData file
with the same format as the expected output.}

\item{counties}{A vector of counties contained in your data. If \code{NULL}, all counties are pulled.
Useful for smaller predictions where only a few counties are considered. Must be zero padded.}
}
\value{
Output will be an object of class \code{list}, indexed by state names. It will
consist of the original user-input data with additional columns of Census geographic data.
}
\description{
\code{census_geo_api} retrieves U.S. Census geographic data for a given state.
}
\details{
This function allows users to download U.S. Census geographic data (2010 or 2020),
at either the county, tract, block, or place level, for a particular state.
}
\examples{
\dontshow{data(voters)}
\dontrun{census_geo_api(states = c("NJ", "DE"), geo = "block")}
\dontrun{census_geo_api(states = "FL", geo = "tract", age = TRUE, sex = TRUE)}
\dontrun{census_geo_api(states = "MA", geo = "place", age = FALSE, sex = FALSE,
 year = "2020")}

}
\references{
Relies on \code{get_census_api()}, \code{get_census_api_2()}, and \code{vec_to_chunk()} functions authored by Nicholas Nagle,
available \href{https://rstudio-pubs-static.s3.amazonaws.com/19337_2e7f827190514c569ea136db788ce850.html}{here}.
}
\keyword{internal}
