% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wn_to_wv}
\alias{wn_to_wv}
\title{Gaussian White Noise to WV}
\usage{
wn_to_wv(sigma2, tau)
}
\arguments{
\item{sigma2}{A \code{double} corresponding to variance of WN}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the white noise.
}
\description{
This function compute the Haar WV of a Gaussian White Noise process
}
\section{Process Haar Wavelet Variance Formula}{

The Gaussian White Noise (WN) process has a Haar Wavelet Variance given by:
\deqn{\nu _j^2\left( {{\sigma ^2}} \right) = \frac{{{\sigma ^2}}}{{\tau _j^2}}}{nu[j]^2 (sigma2) = (sigma2)/(tau[j]^2)}
}

