% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDatesInWindow.R
\name{getDatesInWindow}
\alias{getDatesInWindow}
\title{Get dates in window}
\usage{
getDatesInWindow(syr, eyr, smo, emo, sdate, edate, wwidth, leapflag = FALSE)
}
\arguments{
\item{syr}{Start year.}

\item{eyr}{End year.}

\item{smo}{Start month.}

\item{emo}{End month.}

\item{sdate}{Start date.}

\item{edate}{End date.}

\item{wwidth}{Window set for finding surrounding days (semi-bandwidth).}

\item{leapflag}{Set index for leap years (default = F).}
}
\value{
Returns a matrix with 366 rows (one for each Julian day of year, including leap days)
 and nCols; where nCols = (2 x wwidth + 1) x (eyr - syr + 1). Each row is specific to a certain
 Julian day (e.g., day 1) and contains the preceding and antecedent dates around that Julian day
 based on the window length you set. The dates will be fetched for each year in the range you set
 between the start and ending years (inclusive of the start and end years). Matrix values are either dates
 formatted as 'yyyymmdd' or NA values.
}
\description{
Find grouping of dates around each Julian day of year (1-366) based on the window you set.
The start and end years for this function should include at least one leap year
 (i.e., the record should be at least 4-years in length), or else the function will
 return non-existing dates (February 29th during non-leap years).\cr
 \cr
Setting leapflag to true will set February 29th as NA for non-leap years.\cr
\cr
Setting leapflag to false will remove February 29th for non-leap years (recommended).\cr
\cr
The 'wwidth' variable is the semi-bandwidth that sets the window size to search
for adjacent days. Given a value of 'wwidth', the window size will be
2*wwidth + 1. For example a 'wwidth' of 7 would give a window size of
2*7+1 = 15.\cr
\cr
Other applications of this function might include a daily bias correction approach
where it is necessary to find N adjacent days for each day of year in order to train
the bias correction algorithm.
}
\examples{
 getDatesInWindow(syr = 2000, eyr = 2005, smo = 10, emo = 09,
  sdate = 20001001, edate = 20050930, wwidth = 3, leapflag = FALSE)

}
