% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_sgene}
\alias{xQTLdownload_sgene}
\title{Download details of sGenes (sQTL Genes) for a specified gene or a tissue.}
\usage{
xQTLdownload_sgene(
  gene = "",
  geneType = "auto",
  datasetId = "gtex_v8",
  tissueSiteDetail = "",
  recordPerChunk = 2000
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported). Can be null.}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 2000).}
}
\value{
A data.table object.
}
\description{
sGenes are genes that have at least one significant sQTL acting upon them. Results may be filtered by tissue.
}
\examples{
\donttest{
sGeneInfo <- xQTLdownload_sgene(tissueSiteDetail="Liver")
sGeneInfo <- xQTLdownload_sgene(gene="DDX11", tissueSiteDetail="Liver" )
}
}
