% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_sqtlExp}
\alias{xQTLvisual_sqtlExp}
\title{Boxplot of normalized expression among genotypes for sQTL.}
\usage{
xQTLvisual_sqtlExp(
  variantName = "",
  phenotypeId = "",
  variantType = "auto",
  tissueSiteDetail = "",
  datasetId = "gtex_v8"
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{phenotypeId}{A character string. Format like: "chr1:497299:498399:clu_54863:ENSG00000239906.1"}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}
}
\value{
A list containing variant detail, expression profile and a ggplot object.
}
\description{
Boxplot of normalized expression among genotypes for sQTL.
}
\examples{
expSqtl <-xQTLvisual_sqtlExp(variantName="chr11_66561248_T_C_b38",
          phenotypeId ="chr11:66348070:66353455:clu_8500:ENSG00000255468.6",
          tissueSiteDetail="Skin - Sun Exposed (Lower leg)")
}
