% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_exp}
\alias{xQTLdownload_exp}
\title{Download normalized gene expression at the sample level for a specified tissue.}
\usage{
xQTLdownload_exp(
  genes = "",
  geneType = "auto",
  tissueSiteDetail = "Liver",
  toSummarizedExperiment = FALSE,
  recordPerChunk = 80,
  pathologyNotesCategories = FALSE
)
}
\arguments{
\item{genes}{(character string or a character vector) gene symbols or gencode ids (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{toSummarizedExperiment}{a logical value indicating whether to return a data.frame or a summarizedExperiment object. Default: TRUE, return a toSummarizedExperiment object.}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 80).}

\item{pathologyNotesCategories}{a logical value indicating whether to return pathologyNotes. Default: FALSE, the pathologyNotes is ignored.}
}
\value{
return a SummarizedExperiment or a data.table object harbing gene expression profiles and samples' information.
}
\description{
Download normalized gene expression at the sample level for a specified tissue.
}
\examples{
\donttest{
# Download gene expression with a genecode ID:
expProfiles <- xQTLdownload_exp("ENSG00000210195.2", tissueSiteDetail="Liver")

# Download gene expression into a SummarizedExperiment object:
expProfiles <- xQTLdownload_exp("ENSG00000210195.2", tissueSiteDetail="Liver",
               toSummarizedExperiment=TRUE)
# extract expression profile from SummarizedExperiment object:
expDT <- SummarizedExperiment::assay(expProfiles)
# extract samples' detail from SummarizedExperiment object:
sampleDT <- SummarizedExperiment::colData(expProfiles)

# Download gene expression profiles of multiple genes:
expProfiles <- xQTLdownload_exp(c("tp53","naDK","SDF4"),
                                tissueSiteDetail="Artery - Coronary",
                                pathologyNotesCategories=TRUE)

# Download with versioned and unversioned gencode Id.
expProfiles <- xQTLdownload_exp(c("ENSG00000141510.16","ENSG00000008130.15","ENSG00000078808"),
                               tissueSiteDetail="Artery - Coronary")
}
}
