% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgXMutationFactory.R
\name{sgXMutationFactory}
\alias{sgXMutationFactory}
\title{Factory for configuring a gene-dependent Mutation function.}
\usage{
sgXMutationFactory(algorithm = "sga", method = "MutateGene")
}
\arguments{
\item{algorithm}{Algorithm. 
Available: "sga", "sgde", "sgperm", "sge", sgp". 
Default: "sga".}

\item{method}{Method. Available methods are package-dependent.}
}
\value{
MutateGene  function for the selected  algorithm 
                    from the correct package.
}
\description{
\code{sgXMutationFactory()} selects 
             \enumerate{
             \item the algorithm-specific mutation factory and 
             \item the method in this factory. 
             }
}
\details{
The available methods for each factory are:
   \itemize{
    \item "sga": "MutateGene", "IVM".
    \item "sge": "MutateGene", "IVM".
    \item "sgp": "MutateGene", "MutateAllGene", "MutateFilterGene".
    \item "sgede": "MutateGene", "MutateGeneDE".
    \item "sgde": "MutateGene", "MutateGeneDE".
    \item "sgperm": "MutateGene", "MutateGeneOrderBased", 
          "MutateGenekInversion", "MutateGene2Opt", "MutateGenekOptLK",
          "MutateGeneGreedy", "MutateGeneBestGreedy", "MutateGeneMix".
 }
}
\examples{
sgXMutationFactory(algorithm="sga", method="MutateGene")

}
\seealso{
Other Configuration: 
\code{\link{sgXCrossoverFactory}()},
\code{\link{sgXDecodeGeneFactory}()},
\code{\link{sgXGeneMapFactory}()},
\code{\link{sgXInitGeneFactory}()},
\code{\link{sgXReplicationFactory}()}
}
\concept{Configuration}
