% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{tLCM}
\alias{tLCM}
\title{Computes the largest least common multiple of all prime factors 
of the integers in the interval \code{1:m} for k-bit integers.}
\usage{
tLCM(k)
}
\arguments{
\item{k}{Number of bits.}
}
\value{
A list of three elements:
            \itemize{
            \item \code{$k}: The number of bits.
            \item \code{$m}: Maximal number of substitutions for a non-terminal symbol
                             in a grammar. 
            \item \code{$mLCM}: Least common multiple of the prime factors of
                                all rule choices from 1 to \code{$m}.
            }
}
\description{
For 64 bit numbers, numerically stable up to \code{m==42}.
         The modulo rule in grammatical evolution assigns to the choices 
         of substitutions for a non-terminal slightly (biased) probabilities.
         For an integer coding, the least common multiple of all rule choices 
         from no choice (1) to the maximal number of substitutions of a non-terminal
         removes this bias completely. However, whenever the prime factors of the 
         least common multiple contain a prime different from \code{2}, 
         the bias cannot be removed completely for a binary gene coding. 
         However, each additional bit used for coding approximately halves the bias.
}
\details{
This could be done with the help of 
         the function mLCM of the R-package \code{numbers}. 
         We implement this by enumerating the vector of prime factors  
         in \code{1:42}.
}
\examples{
  tLCM(8)
  tLCM(16)
  tLCM(32)
}
\seealso{
Other Diagnostics: 
\code{\link{CodonChoiceBiasesDeprecated}()},
\code{\link{CodonChoiceBiases}()},
\code{\link{CodonPrecision}()}
}
\concept{Diagnostics}
