% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeDecode.R
\name{xegaGeGeneMapMod}
\alias{xegaGeGeneMapMod}
\title{Map the bit strings of a binary gene to parameters in the interval
\code{1:2^k}.}
\usage{
xegaGeGeneMapMod(gene, lF)
}
\arguments{
\item{gene}{Binary gene (the genotype).}

\item{lF}{Local configuration.}
}
\value{
Integer vector.
}
\description{
\code{xegaGeGeneMapMod()} maps the bit strings of a binary string 
             to integers in the interval \code{1} to 
             \code{lF$CodonPrecision()}. 
             Bit vectors are mapped into equispaced numbers in the interval.
}
\details{
The modulo rule of grammatical evolution produces (slightly)
         biased choices of rules with this mapping. The bias goes to 
         zero as \code{lF$CodonPrecision()} \code{>>} number of rules 
         to choose from.
}
\examples{
gene<-xegaGeInitGene(lFxegaGeGene)
xegaGeGeneMapMod(gene$gene1, lFxegaGeGene)

}
\references{
Keijzer, M., O'Neill, M., Ryan, C. and Cattolico, M. (2002)
         Grammatical Evolution Rules: The Mod and the Bucket Rule,
         pp. 123-130. 
         In: Foster, J. A., Lutton, E., Miller, J., Ryan, C. and 
             Tettamanzi, A. (Eds.): Genetic Programming.
         Lecture Notes in Computer Science, Vol.2278, 
             Springer, Heidelberg. 
         <doi:10.1007/3-540-45984-7_12>
}
\seealso{
Other Decoder: 
\code{\link{xegaGeDecodeGene}()},
\code{\link{xegaGeGeneMapmLCM}()}
}
\concept{Decoder}
