% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPopulation.R
\name{xegaBestGeneInPopulation}
\alias{xegaBestGeneInPopulation}
\title{Extracts indices of best genes in population.}
\usage{
xegaBestGeneInPopulation(fit)
}
\arguments{
\item{fit}{Fitness vector of a population of genes.}
}
\value{
List of the indices of the best genes in the population.
}
\description{
\code{BestGeneInPopulation()} extracts the indices of
             the best genes in the population.
}
\details{
You might use:   
 \code{which(max(fit)==fit)}. But this is slower!
}
\examples{
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
xegaBestGeneInPopulation(epop10$fit)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaSummaryPopulation}()}
}
\concept{Population Layer}
