% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{Rscript_call}
\alias{Rscript_call}
\title{Call a function in a new R session via \code{Rscript()}}
\usage{
Rscript_call(fun, args = list())
}
\arguments{
\item{fun}{A function, or a character string that can be parsed and evaluated
to a function.}

\item{args}{A list of argument values.}
}
\value{
The returned value of the function in the new R session.
}
\description{
Save the argument values of a function in a temporary RDS file, open a new R
session via \code{\link{Rscript}()}, read the argument values, call the
function, and read the returned value back to the current R session.
}
\examples{
factorial(10)
# should return the same value
xfun::Rscript_call("factorial", list(10))

# the first argument can be either a character string or a function
xfun::Rscript_call(factorial, list(10))
}
