% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github_releases}
\alias{github_releases}
\title{Get the tags of GitHub releases of a repository}
\usage{
github_releases(
  repo,
  tag = "",
  pattern = "v[0-9.]+",
  use_jsonlite = loadable("jsonlite")
)
}
\arguments{
\item{repo}{The repository name of the form \code{user/repo}, e.g.,
\code{"yihui/xfun"}.}

\item{tag}{A tag as a character string. If provided, it will be returned if
the tag exists. If \code{tag = "latest"}, the tag of the latest release is
returned.}

\item{pattern}{A regular expression to match the tags.}

\item{use_jsonlite}{Whether to use \pkg{jsonlite} to parse the releases info.}
}
\value{
A character vector of (GIT) tags.
}
\description{
Use the GitHub API (\code{\link[=github_api]{github_api()}}) to obtain the tags of the
releases.
}
\examples{\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
xfun::github_releases("yihui/xfun")
xfun::github_releases("gohugoio/hugo")
\dontshow{\}) # examplesIf}
}
