% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.xhaz.constant.R
\name{predict.constant}
\alias{predict.constant}
\title{Predictions of excess hazard and net Survival from an \code{constant}
object}
\usage{
\method{predict}{constant}(object, new.data = NULL, times.pts = NULL, baseline = TRUE, ...)
}
\arguments{
\item{object}{An object of class constant}

\item{new.data}{new.data where is covariates}

\item{times.pts}{time in year scale to calculate the excess hazard. The
default value is NULL. In this case, time variable must be provided in the
new.data}

\item{baseline}{default is survival baseline; put \code{baseline = FALSE}
to estimate the net survival with covariates}

\item{...}{additional arguments affecting the predictions of excess hazard
and net survival}
}
\value{
An object of class predxhaz. The return of this fonction can be
used to produce graphics of excess hazard or net survival, when times.pts argument is provided. This object
contains:

\item{times.pts}{the times value in year at which the excess hazard and or the net survival have been estimated}

\item{hazard}{the excess hazard values based on the model of interest}

\item{survival}{the net survival values based on the model of interest}
}
\description{
Function to predict excess hazard and net survival based on an
object of class \code{constant}. The function allows the
predictions at several time points but not exceeding the maximum time of
follow-up from the baseline model.
}
\examples{

# load the data set in the package
library("xhaz")
library("numDeriv")

# load the data sets 'simuData

data("simuData", package = "xhaz")

#define the levels of variable sex
levels(simuData$sex) <- c("male", "female")

# Esteve et al. model

set.seed(1980)
simuData2 <- simuData[sample(nrow(simuData), size = 500), ]

fit.estv2 <- xhaz(formula = Surv(time_year, status) ~ agec + race,
                  data = simuData2,
                  ratetable = survexp.us,
                  interval = c(0, NA, NA, NA, NA, NA, 6),
                  rmap = list(age = 'age', sex = 'sex', year = 'date'),
                  baseline = "constant", pophaz = "classic")


predict_est <- predict(object = fit.estv2,
                       new.data = simuData2,
                       times.pts = c(seq(0, 4, 1)),
                       baseline = TRUE)
predict_est

}
\references{
Goungounga JA, Touraine C, Grafféo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Touraine C, Grafféo N, Giorgi R; CENSUR working survival group.
More accurate cancer-related excess mortality through correcting
background mortality for extra variables.
Stat Methods Med Res. 2020 Jan;29(1):122-136.
doi: 10.1177/0962280218823234. Epub 2019 Jan 23. PMID: 30674229.
(\href{https://pubmed.ncbi.nlm.nih.gov/30674229/}{PubMed})

Mba RD, Goungounga JA, Grafféo N, Giorgi R; CENSUR working survival group.
Correcting inaccurate background mortality in excess hazard models
through breakpoints. BMC Med Res Methodol. 2020 Oct 29;20(1):268.
doi: 10.1186/s12874-020-01139-z. PMID: 33121436; PMCID: PMC7596976.
(\href{https://pubmed.ncbi.nlm.nih.gov/33121436/}{PubMed})
}
\seealso{
\code{\link{xhaz}}, \code{\link{print.bsplines}}, \code{\link{print.constant}}
}
\author{
Juste Goungounga, Robert Darlin Mba, Nathalie Grafféo and Roch Giorgi
}
\keyword{predict.constant}
