% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEffects_Account.R
\name{getEffects_Account}
\alias{getEffects_Account}
\title{Get an overview of account effects on the Stellar ledger.}
\usage{
getEffects_Account(pk, cursor = NULL, limit = 10, order = "asc",
  data.table = TRUE, domain = "public")
}
\arguments{
\item{pk}{character - your Stellar account/wallet address.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public".}
}
\value{
data.table (by default) or list
}
\description{
Returns effects from the creation of the account to the current ledger. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/accounts-single.html
}
\examples{
\dontrun{getEffects_Account("GCO2IP3MJNUOKS4PUDI4C7LGGMQDJGXG3COYX3WSB4HHNAHKYV5YL3VC")}
}
