% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addXLSheetStd.R
\name{addXLsheetStd}
\alias{addXLsheetStd}
\title{Add a sheet to the 'Excel' workbook}
\usage{
addXLsheetStd(wbList = XL.wb, df = NA, sheetName = NA, descrip = NA)
}
\arguments{
\item{wbList}{list with workbook and default cell styles (i.e., output from getXLsettings)}

\item{df}{data frame to output to sheet}

\item{sheetName}{sheet name}

\item{descrip}{description of sheet}
}
\value{
list with workbook and default cell styles
}
\description{
Add a sheet to the 'Excel' workbook
}
\details{
The \code{sheetName} is the name that will be used for the sheet. When
\code{sheetName} is not specified, the name of the \code{df} will be used. The
\code{descrip} is a character string that will be placed into cell A1 of the sheet
and is best used to provide a brief description of the sheet; and the dataframe
will begin at cell A3. If \code{descrip} is not specified, then the dataframe will
begin at cell A1. The outputted table will have filters turned on and table headers
and first column frozen.
}
\examples{
XL.wb <- getXLsettings()
XL.wb <- addXLsheetStd(XL.wb, mtcars)
XL.wb <- addXLsheetStd(XL.wb, mtcars, "mtcars1")
XL.wb <- addXLsheetStd(XL.wb, mtcars, "mtcars2", "Standard mtcars data frame")
XL.wb$pName <- "ProjName" # optional, blank if not included
XL.wb$pDesc <- "ProjDesc" # optional, blank if not included
saveXLworkbook(XL.wb, file.path(tempdir(), 'myXLfile.xlsx'), timeStamp=FALSE, clean=FALSE)
saveXLworkbook(XL.wb, file.path(tempdir(), 'myXLfile.xlsx'), timeStamp=TRUE,  clean=FALSE)
saveXLworkbook(XL.wb, file.path(tempdir(), 'myXLfile.xlsx'), timeStamp=TRUE,  clean=TRUE)
saveXLworkbook(XL.wb, file.path(tempdir(), 'myXLfile.xlsx'))

}
