% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.checkout.R
\name{data.checkout}
\alias{data.checkout}
\title{Check through the source dataset to detect problems}
\usage{
data.checkout(
  obj = NULL,
  datafile = ".ask.",
  hlin = -99,
  dotcol = "black",
  dotpch = 16,
  dotcex = 1,
  idlab = "ID",
  csv = NULL,
  main = "Default",
  ...
)
}
\arguments{
\item{obj}{NULL or an xpose.data object.}

\item{datafile}{A data file, suitable for import by
\code{\link{read.table}}.}

\item{hlin}{An integer, specifying the line number on which the column
headers appear.}

\item{dotcol}{Colour for the dots in the dotplot. If obj is an xpose data
object then the default is to use the same value as defined for
box-and-whisker plots.}

\item{dotpch}{Plotting character for the dots in the dotplot. If obj is an
xpose data object then the default is to use the same value as defined for
box-and-whisker plots.}

\item{dotcex}{Relative scaling for the dots in the dotplot.  If obj is an
xpose data object then the default is to use the same value as defined for
box-and-whisker plots.}

\item{idlab}{The ID column label in the dataset.  Input as a text string.}

\item{csv}{Is the data file in CSV format (comma separated values)?  If the
value is \code{NULL} then the user is asked at the command line.  If
supplied to the function the value can be \code{TRUE/FALSE}.}

\item{main}{The title to the plot. "default" means that Xpose creates a
title.}

\item{\dots}{Other arguments passed to \code{link[lattice]{dotplot}}.}
}
\value{
A stack of dotplots.
}
\description{
This function graphically "checks out" the dataset to identify errors or
inconsistencies.
}
\details{
This function creates a series of \code{dotplots}, one for each variable in
the dataset, against individual ID. Outliers and clusters may easily be
detected in this manner.
}
\examples{

\dontrun{
## We expect to find the required NONMEM run, table and data files for run
## 5 in the current working directory 
xpdb5 <- xpose.data(5)

data.checkout(xpdb5, datafile = "mydata.dta")
data.checkout(datafile = "mydata.dta")
}

}
\seealso{
\code{\link[lattice]{dotplot}}, \code{\link{xpose.prefs-class}},
\code{\link{read.table}}

Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Niclas Jonsson, Andrew Hooker & Justin Wilkins
}
\concept{data functions}
\concept{specific functions}
\keyword{methods}
